<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:proj_cache="http://tempuri.org/ProjectCache.xsd"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:wwexec="urn:WebWorks-XSLT-Extension-Execute"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl wwexec msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
<!--
    This transform is specific to Nuance Help
  -->

 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalFiles" />

 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwsplits-split-by-documentid" match="wwsplits:Split" use="@documentID" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>

 <xsl:variable name="VarProjectChecksum" select="$GlobalProject/wwproject:Project/@ChangeID" />


 <!-- Main -->
 <!--      -->
 <xsl:template match="/">
  <wwfiles:Files version="1.0">

  <xsl:variable name="VarIgnore1Start" select="wwprogress:Start(1)" />
  <xsl:variable name="VarIgnore1Status" select="wwprogress:SetStatus('Generating Nuance files')" />

   <!-- Call directory copy -->
   <xsl:call-template name="CopyCustomFiles" />

   <xsl:variable name="VarIgnore1End" select="wwprogress:End()" />

   </wwfiles:Files>
 </xsl:template>

 <!-- Copy custom files -->
 <!--                        -->
 <xsl:template name="CopyCustomFiles">

   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:for-each select="$VarProjectGroups">
     <xsl:variable name="VarProjectGroup" select="." />

     <!-- NOTE: Source is hard-coded -->
     <xsl:variable name="VarSourceDirectoryPath" select="'C:\_wwfiles\files'" />
     <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($VarProjectGroup/@GroupID) )" />

     <xsl:if test="wwfilesystem:DirectoryExists($VarSourceDirectoryPath)" >
       <xsl:variable name="VarLogCopy" select="wwlog:Warning('[Custom] Copying files from ',$VarSourceDirectoryPath, ' to ', $VarOutputDirectoryPath)" />
       <xsl:variable name="VarCopiedFiles" select="wwfilesystem:CopyDirectoryFiles($VarSourceDirectoryPath,$VarOutputDirectoryPath)"  />

       <!-- Add them to the deploy list -->
       <xsl:for-each select="$VarCopiedFiles/wwfiles:Files/wwfiles:File">
          <xsl:copy>
            <xsl:for-each select="@*">
              <xsl:choose>
                <xsl:when test="string(name(.)) = 'groupID'">
                  <xsl:attribute name="groupID">
                    <xsl:value-of select="$VarProjectGroup/@GroupID" />
                  </xsl:attribute>
                </xsl:when>

                <xsl:otherwise>
                  <xsl:copy-of select="." />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:for-each>
            <xsl:attribute name="deploy">
              <xsl:text>true</xsl:text>
            </xsl:attribute>

            <xsl:copy-of select="./*" />
          </xsl:copy>
       </xsl:for-each>

     </xsl:if>
   </xsl:for-each>
 </xsl:template>

</xsl:stylesheet>
